/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.basic.AbstractBook;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.sword.Backend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.processing.RawTextToXmlProcessor;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.ReadOnlyKeyList;
import org.crosswire.jsword.passage.VerseRange;
import org.jdom2.Content;

public class SwordGenBook
extends AbstractBook {
    private Key global;
    private boolean active;
    private Map<String, Key> map;
    private Key set;
    protected Filter filter;

    protected SwordGenBook(SwordBookMetaData sbmd, Backend backend) {
        super(sbmd, backend);
        if (backend == null) {
            throw new IllegalArgumentException("AbstractBackend must not be null.");
        }
        this.filter = sbmd.getFilter();
        this.map = null;
        this.set = null;
        this.global = null;
        this.active = false;
    }

    @Override
    public final void activate(Lock lock) {
        super.activate(lock);
        this.set = this.getBackend().readIndex();
        this.map = new HashMap<String, Key>();
        for (Key key : this.set) {
            this.map.put(key.getOsisRef(), key);
        }
        this.global = new ReadOnlyKeyList(this.set, false);
        this.active = true;
    }

    @Override
    public final void deactivate(Lock lock) {
        super.deactivate(lock);
        this.map = null;
        this.set = null;
        this.global = null;
        this.active = false;
    }

    @Override
    public Iterator<Content> getOsisIterator(Key key, boolean allowEmpty, boolean allowGenTitle) throws BookException {
        this.checkActive();
        assert (key != null);
        return this.getBackend().readToOsis(key, new RawTextToXmlProcessor(){

            @Override
            public void preRange(VerseRange range, List<Content> partialDom) {
            }

            @Override
            public void postVerse(Key verse, List<Content> partialDom, String rawText) {
                partialDom.addAll(SwordGenBook.this.filter.toOSIS(SwordGenBook.this, verse, rawText));
            }

            @Override
            public void init(List<Content> partialDom) {
            }
        }).iterator();
    }

    @Override
    public String getRawText(Key key) throws BookException {
        return this.getBackend().getRawText(key);
    }

    @Override
    public boolean contains(Key key) {
        return this.getBackend().contains(key);
    }

    @Override
    public List<Content> getOsis(Key key, RawTextToXmlProcessor processor) throws BookException {
        this.checkActive();
        assert (key != null);
        return this.getBackend().readToOsis(key, processor);
    }

    @Override
    public boolean isWritable() {
        return this.getBackend().isWritable();
    }

    @Override
    public void setRawText(Key key, String rawData) throws BookException {
        throw new BookException(JSOtherMsg.lookupText("This Book is read-only.", new Object[0]));
    }

    @Override
    public void setAliasKey(Key alias, Key source) throws BookException {
        throw new BookException(JSOtherMsg.lookupText("This Book is read-only.", new Object[0]));
    }

    @Override
    public Key getGlobalKeyList() {
        this.checkActive();
        return this.global;
    }

    @Override
    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    @Override
    public Key getKey(String text) throws NoSuchKeyException {
        this.checkActive();
        Key key = this.map.get(text);
        if (key != null) {
            return key;
        }
        for (String keyName : this.map.keySet()) {
            if (!keyName.equalsIgnoreCase(text)) continue;
            return this.map.get(keyName);
        }
        for (String keyName : this.map.keySet()) {
            if (!keyName.startsWith(text)) continue;
            return this.map.get(keyName);
        }
        for (String keyName : this.map.keySet()) {
            if (keyName.indexOf(text) == -1) continue;
            return this.map.get(keyName);
        }
        throw new NoSuchKeyException(JSMsg.gettext("No entry for '{0}' in {1}.", text, this.getInitials()));
    }

    @Override
    public Key createEmptyKeyList() {
        return new DefaultKeyList();
    }

    private void checkActive() {
        if (!this.active) {
            Activator.activate(this);
        }
    }
}

