/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.activate;

import java.util.HashSet;
import java.util.Set;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Kill;
import org.crosswire.common.activate.Lock;

public final class Activator {
    private static Set<Activatable> activated = new HashSet<Activatable>();
    private static Lock lock = new Lock();

    private Activator() {
    }

    public static void activate(Activatable subject) {
        if (!activated.contains(subject) && subject != null) {
            subject.activate(lock);
            activated.add(subject);
        }
    }

    public static void reduceMemoryUsage(Kill amount) {
        amount.reduceMemoryUsage();
    }

    public static void deactivate(Activatable subject) {
        if (activated.contains(subject) && subject != null) {
            subject.deactivate(lock);
            activated.remove(subject);
        }
    }

    public static void deactivateAll() {
        for (Activatable item : activated) {
            Activator.deactivate(item);
        }
    }
}

