/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CWAction
extends AbstractAction {
    public static final String LARGE_ICON = "LargeIcon";
    public static final String TOOL_TIP = "ToolTip";
    private EventListenerList listeners;
    private static final Logger log = LoggerFactory.getLogger(CWAction.class);
    private static final long serialVersionUID = 3258416148742484276L;

    public CWAction setLargeIcon(Icon icon) {
        this.putValue(LARGE_ICON, icon);
        return this;
    }

    public CWAction setLargeIcon(String iconPath) {
        return this.setLargeIcon(GuiUtil.getIcon(iconPath));
    }

    public CWAction setTooltip(String tooltip) {
        this.putValue("ShortDescription", tooltip);
        return this;
    }

    public CWAction setSmallIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
        return this;
    }

    public CWAction setSmallIcon(String iconPath) {
        return this.setSmallIcon(GuiUtil.getIcon(iconPath));
    }

    public CWAction setAccelerator(String acceleratorSpec) {
        this.putValue("AcceleratorKey", this.getAccelerator(acceleratorSpec));
        return this;
    }

    public CWAction enable(boolean newEnabled) {
        this.setEnabled(newEnabled);
        return this;
    }

    public CWAction setListener(ActionListener listener) {
        CWAction action = this;
        if (listener != null) {
            action = action.clone();
            action.addActionListener(listener);
        }
        return action;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.listeners != null) {
            Object[] listenerList = this.listeners.getListenerList();
            ActionEvent e = new ActionEvent(evt.getSource(), evt.getID(), (String)this.getValue("ActionCommandKey"));
            for (int i = 0; i <= listenerList.length - 2; i += 2) {
                ((ActionListener)listenerList[i + 1]).actionPerformed(e);
            }
        }
    }

    public void addActionListener(ActionListener listener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(ActionListener.class, listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name:");
        sb.append((String)this.getValue("Name"));
        sb.append("\n Desc:");
        sb.append((String)this.getValue("ShortDescription"));
        sb.append("\n    ActionCommandKey:");
        sb.append((String)this.getValue("ActionCommandKey"));
        sb.append("\n    Enabled:");
        sb.append(this.isEnabled());
        sb.append("\n    ObjectID:");
        sb.append(System.identityHashCode(this));
        sb.append('\n');
        return sb.toString();
    }

    @Override
    public CWAction clone() {
        CWAction action;
        block2: {
            action = null;
            try {
                action = (CWAction)super.clone();
                action.listeners = null;
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return action;
    }

    private KeyStroke getAccelerator(String acceleratorSpec) {
        KeyStroke accelerator = null;
        if (acceleratorSpec != null && acceleratorSpec.length() > 0) {
            try {
                accelerator = this.getKeyStroke(acceleratorSpec);
            }
            catch (NumberFormatException nfe) {
                log.warn("Could not parse integer for accelerator of action", (Throwable)nfe);
            }
        }
        return accelerator;
    }

    private KeyStroke getKeyStroke(String acceleratorSpec) throws NumberFormatException {
        int keyModifier = 0;
        int key = 0;
        String[] parts = StringUtil.splitAll((String)acceleratorSpec, (char)',');
        for (int j = 0; j < parts.length; ++j) {
            String part = parts[j].trim();
            if ("ctrl".equalsIgnoreCase(part)) {
                keyModifier |= Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                continue;
            }
            if ("shift".equalsIgnoreCase(part)) {
                keyModifier |= 1;
                continue;
            }
            if ("alt".equalsIgnoreCase(part)) {
                keyModifier |= 8;
                continue;
            }
            if (part.startsWith("0x")) {
                key = Integer.parseInt(part.substring(2), 16);
                continue;
            }
            if (part.length() != 1) continue;
            key = part.charAt(0);
        }
        return KeyStroke.getKeyStroke(key, keyModifier);
    }
}

