/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.Config;
import org.crosswire.common.config.ConfigEvent;
import org.crosswire.common.config.ConfigListener;
import org.crosswire.common.config.swing.ButtonPaneListener;
import org.crosswire.common.config.swing.ConfigEditor;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.config.swing.FieldMap;
import org.crosswire.common.swing.FormPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.desktop.LayoutPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigEditor
extends JPanel
implements ConfigEditor,
ButtonPaneListener {
    protected int cards;
    protected ActionListener al;
    protected Config config;
    protected JDialog dialog;
    protected Map<String, FormPane> decks = new HashMap<String, FormPane>();
    protected Map<String, Field> fields = new HashMap<String, Field>();
    protected static final ImageIcon TASK_ICON_LARGE = GuiUtil.getIcon("toolbarButtonGraphics/general/Preferences24.gif");
    protected static final ImageIcon TASK_ICON_SMALL = GuiUtil.getIcon("toolbarButtonGraphics/general/Preferences16.gif");
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigEditor.class);
    private static final long serialVersionUID = 6004078142151397638L;

    @Override
    public void construct(Config aConfig) {
        this.config = aConfig;
        this.initializeGUI();
        this.config.addConfigListener(new ConfigListener(){

            public void choiceAdded(ConfigEvent ev) {
                AbstractConfigEditor.this.addChoice(ev.getChoice());
                AbstractConfigEditor.this.updateTree();
            }

            public void choiceRemoved(ConfigEvent ev) {
                AbstractConfigEditor.this.removeChoice(ev.getChoice());
                AbstractConfigEditor.this.updateTree();
            }
        });
        for (Choice model : this.config) {
            this.addChoice(model);
        }
        this.updateTree();
        GuiUtil.applyDefaultOrientation(this);
        SwingUtilities.updateComponentTreeUI(this);
    }

    @Override
    public void showDialog(Component parent, ActionListener newal) {
        this.al = newal;
        if (this.dialog == null) {
            Component root = SwingUtilities.getRoot(parent);
            this.dialog = new JDialog((JFrame)root);
            this.dialog.getContentPane().add(this);
            this.dialog.setName("Config");
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent ev) {
                    AbstractConfigEditor.this.hideDialog();
                }
            });
        }
        this.localToScreen();
        this.dialog.setTitle(this.config.getTitle());
        LayoutPersistence layoutPersistence = LayoutPersistence.instance();
        if (layoutPersistence.isLayoutPersisted(this.dialog)) {
            layoutPersistence.restoreLayout(this.dialog);
        } else {
            this.dialog.setSize(1000, 500);
            GuiUtil.centerOnScreen(this.dialog);
        }
        this.dialog.setModal(true);
        GuiUtil.applyDefaultOrientation(this.dialog);
        this.dialog.setVisible(true);
    }

    protected abstract void initializeGUI();

    protected abstract void updateTree();

    @Override
    public void okPressed(ActionEvent ev) {
        this.screenToLocal();
        this.al.actionPerformed(ev);
        this.hideDialog();
    }

    @Override
    public void cancelPressed(ActionEvent ev) {
        this.hideDialog();
    }

    @Override
    public void applyPressed(ActionEvent ev) {
        this.screenToLocal();
        this.al.actionPerformed(ev);
    }

    protected void addChoice(Choice model) {
        if (model.isHidden()) {
            return;
        }
        String key = model.getKey();
        String path = Config.getPath((String)model.getFullPath());
        Field field = FieldMap.getField(model);
        this.fields.put(key, field);
        FormPane card = this.decks.get(path);
        if (card == null) {
            card = new FormPane();
            this.decks.put(path, card);
            ++this.cards;
        }
        JComponent comp = field.getComponent();
        String name = Config.getLeaf((String)model.getFullPath()) + ':';
        card.addEntry(name, model.getHelpText(), comp);
        String value = this.config.getLocal(key);
        field.setValue(value);
    }

    protected void removeChoice(Choice model) {
        String key = model.getKey();
        String path = Config.getPath((String)model.getFullPath());
        Field field = this.fields.get(key);
        if (field != null) {
            this.fields.remove(key);
            FormPane card = this.decks.get(path);
            String name = Config.getLeaf((String)model.getFullPath()) + ':';
            card.removeEntry(name);
            if (card.isEmpty()) {
                this.decks.remove(path);
            }
        }
    }

    protected void hideDialog() {
        if (this.dialog != null) {
            LayoutPersistence.instance().saveLayout(this.dialog);
            this.dialog.setVisible(false);
        }
    }

    protected void screenToLocal() {
        for (Choice choice : this.config) {
            if (choice.isHidden()) continue;
            String key = choice.getKey();
            Field field = this.fields.get(key);
            String value = field.getValue();
            if (value == null) {
                log.error("null value from key={}", (Object)key);
            }
            this.config.setLocal(key, value);
        }
    }

    protected void localToScreen() {
        for (Choice choice : this.config) {
            if (choice.isHidden()) continue;
            String key = choice.getKey();
            Field field = this.fields.get(key);
            String value = this.config.getLocal(key);
            if (field == null) {
                log.error("Null field from key={}, skipping setting value={}", (Object)key, (Object)value);
                continue;
            }
            field.setValue(value);
        }
    }
}

