/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.crosswire.bibledesktop.book.BibleComboBoxModelSet;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.versification.BibleBook;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BibleComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private transient Versification v11n = Versifications.instance().getVersification("KJV");
    private transient BibleComboBoxModelSet set;
    private transient Object selected;
    protected Level level;
    private static final Logger log = LoggerFactory.getLogger(BibleComboBoxModel.class);
    private static final long serialVersionUID = 3616449020667442997L;

    protected BibleComboBoxModel(BibleComboBoxModelSet set, Level level) {
        this.set = set;
        this.level = level;
        switch (level) {
            case BOOK: {
                this.selected = set.getVerse().getVersification().getBookName(set.getVerse().getBook());
                break;
            }
            case CHAPTER: {
                this.selected = set.getVerse().getChapter();
                break;
            }
            case VERSE: {
                this.selected = set.getVerse().getVerse();
                break;
            }
            default: {
                assert (false) : level;
                break;
            }
        }
    }

    @Override
    public void setSelectedItem(Object selected) {
        log.debug("setSelectedItem({}) level={}", selected, (Object)this.level);
        switch (this.level) {
            case BOOK: {
                BibleBook book = (BibleBook)selected;
                assert (book != null);
                this.setBook(book);
                break;
            }
            case CHAPTER: {
                Integer csel = (Integer)selected;
                this.setChapter(csel);
                break;
            }
            case VERSE: {
                Integer vsel = (Integer)selected;
                this.setVerse(vsel);
                break;
            }
            default: {
                assert (false) : this.level;
                break;
            }
        }
        this.selected = selected;
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public int getSize() {
        switch (this.level) {
            case BOOK: {
                return this.v11n.getBookCount();
            }
            case CHAPTER: {
                return this.v11n.getLastChapter(this.set.getVerse().getBook());
            }
            case VERSE: {
                return this.v11n.getLastVerse(this.set.getVerse().getBook(), this.set.getVerse().getChapter());
            }
        }
        assert (false) : this.level;
        return 0;
    }

    @Override
    public Object getElementAt(int index) {
        switch (this.level) {
            case BOOK: {
                return this.v11n.getBook(index);
            }
        }
        return index + 1;
    }

    public void setBook(BibleBook book) {
        Verse old = this.set.getVerse();
        int chapter = old.getChapter();
        int verse = old.getVerse();
        chapter = Math.min(chapter, this.v11n.getLastChapter(book));
        verse = Math.min(verse, this.v11n.getLastVerse(book, chapter));
        Verse update = new Verse(this.v11n, book, chapter, verse);
        this.set.setVerse(update);
    }

    public void setChapter(int chapter) {
        Verse old = this.set.getVerse();
        BibleBook book = old.getBook();
        int verse = old.getVerse();
        verse = Math.min(verse, this.v11n.getLastVerse(book, chapter));
        Verse update = new Verse(this.v11n, book, chapter, verse);
        this.set.setVerse(update);
    }

    public void setVerse(int verse) {
        Verse old = this.set.getVerse();
        Verse update = new Verse(this.v11n, old.getBook(), old.getChapter(), verse);
        this.set.setVerse(update);
    }

    @Override
    protected void fireContentsChanged(Object source, int index0, int index1) {
        super.fireContentsChanged(source, index0, index1);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.set = null;
        this.selected = null;
        this.v11n = Versifications.instance().getVersification("KJV");
        is.defaultReadObject();
    }

    protected static enum Level {
        BOOK,
        CHAPTER,
        VERSE;

    }
}

